/*
 * Copyright (c) 2012-2017, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * */
/*
 * ======== daemonif.h ========
 *
 * Simple network daemon
 *
 */

#ifndef _DAEMONIF_H
#define _DAEMONIF_H

#ifdef __cplusplus
extern "C" {
#endif

extern void *DaemonNew( uint32_t Type, uint32_t LocalAddress, uint32_t LocalPort,
                          int (*pCb)(SOCKET,uint32_t), uint32_t Priority,
                          uint32_t StackSize, uintptr_t Argument, uint32_t MaxSpawn );

extern void DaemonFree( void *hEntry );

#ifdef _INCLUDE_IPv6_CODE
extern void *Daemon6New( uint32_t Type, IP6N LocalAddress, uint32_t LocalPort,
                          int (*pCb)(SOCKET,uint32_t), uint32_t Priority,
                          uint32_t StackSize, uintptr_t Argument, uint32_t MaxSpawn );

extern void Daemon6Free( void *hEntry );
#endif /* _INCLUDE_IPv6_CODE */

#ifdef __cplusplus
}
#endif /* extern "C" */

#endif
