#
#  ======== ndk.mak ========
#

#
# Where to install/stage the packages
# Typically this would point to the devkit location
#
DESTDIR ?= <UNDEFINED>

prefix ?= /
docdir ?= /docs/ndk
packagesdir ?= /source

# USER STEP: user must define below path to xdc installation
# Set up dependencies
XDC_INSTALL_DIR ?= C:/ti/xdctools_version
SYSBIOS_INSTALL_DIR ?= C:/ti/simplelink_msp432e4_sdk_version/kernel/tirtos
TIPOSIX_REPO ?= C:/ti/simplelink_msp432e4_sdk_version/source
NS_INSTALL_DIR ?= C:/ti/simplelink_msp432e4_sdk_version/source
MBEDTLS_INSTALL_DIR ?= C:/ti/simplelink_msp432e4_sdk_version/source/third_party/mbedtls
MWARE_INSTALL_DIR ?= C:/ti/c2000-f2838x-driverlib/driverlib_cm

#
# Set location of various cgtools
# These variables can be set here or on the command line.
#
# USER STEP: user must define below paths to compilers
ti.targets.arm.elf.M4 ?=

# Set BUILDMINSTACK to 1 to only build base stack libraries (stk.a* and stk6.a*)
BUILDMINSTACK ?= 0

#
# Set XDCARGS to some of the variables above.  XDCARGS are passed
# to the XDC build engine... which will load ndk.bld... which will
# extract these variables and use them to determine what to build and which
# toolchains to use.
#
# Note that not all of these variables need to be set to something valid.
# Unfortunately, since these vars are unconditionally assigned, your build line
# will be longer and more noisy than necessary
#
# Some background is here:
#     http://rtsc.eclipse.org/docs-tip/Command_-_xdc#Environment_Variables
#
XDCARGS= \
    ti.targets.arm.elf.M4=\"$(ti.targets.arm.elf.M4)\" \
    BUILDMINSTACK=\"$(BUILDMINSTACK)\" \
    TIPOSIX_REPO=\"$(TIPOSIX_REPO)\" \
    MBEDTLS_INSTALL_DIR=$(MBEDTLS_INSTALL_DIR) \
    MWARE_INSTALL_DIR=$(MWARE_INSTALL_DIR) \
    NS_INSTALL_DIR=\"$(NS_INSTALL_DIR)\"

#
# Set XDCPATH to contain necessary repositories.
#
XDCPATH = $(SYSBIOS_INSTALL_DIR)/packages;
export XDCPATH

#
# Set XDCOPTIONS.  Use -v for a verbose build.
#
#XDCOPTIONS=v
export XDCOPTIONS

j = 8
#
# Set XDC executable command
# Note that XDCBUILDCFG points to the ndk.bld file which uses
# the arguments specified by XDCARGS
#
XDC = $(XDC_INSTALL_DIR)/xdc -j $(j) XDCARGS="$(XDCARGS)" XDCBUILDCFG=./ndk.bld

######################################################
## Shouldnt have to modify anything below this line ##
######################################################

all:
	@ echo building ndk packages ...
	@ $(XDC) -Pr ./source

clean:
	@ echo cleaning ndk packages ...
	@ $(XDC) clean -Pr ./source

install-packages:
	@ echo installing ndk packages to $(DESTDIR) ...
	@ mkdir -p $(DESTDIR)/$(prefix)/$(docdir)
	@ cp -rf $(wildcard ndk_*_ReleaseNotes.html) docs/* $(DESTDIR)/$(prefix)/$(docdir)
	@ mkdir -p $(DESTDIR)/$(prefix)/$(packagesdir)
	@ cp -rf source/* $(DESTDIR)/$(prefix)/$(packagesdir)
